﻿-- Refresh the VIEW Structure on VoxcoSystem.tblAgents table
IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'tblAgents') 
    DROP View [dbo].[tblAgents] 
GO
create view dbo.tblAgents as select * from #VoxcoSystemDatabaseName#.dbo.tblAgents
GO

-- Refresh the VIEW Structure on VoxcoSystem.tblObjects table
IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'tblObjects') 
    DROP View [dbo].[tblObjects] 
GO
create view dbo.tblObjects as select * from #VoxcoSystemDatabaseName#.dbo.tblObjects
GO

-- Refresh the VIEW Structure on VoxcoSystem.tblPages table
IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'tblPages') 
    DROP View [dbo].[tblPages] 
GO
create view dbo.tblPages as select * from #VoxcoSystemDatabaseName#.dbo.tblPages
GO


-- Refresh the VIEW Structure on VoxcoSystem.IntWeb_ActiveSessions table
IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'IntWeb_ActiveSessions') 
    DROP View [dbo].[IntWeb_ActiveSessions] 
GO
create view dbo.IntWeb_ActiveSessions as select * from #VoxcoSystemDatabaseName#.dbo.IntWeb_ActiveSessions
GO


--CAPI_FileReceived
-- Refresh the VIEW Structure on VoxcoSystem.CAPI_FileReceived table
IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'CAPI_FileReceived') 
    DROP View [dbo].CAPI_FileReceived 
GO
create view dbo.CAPI_FileReceived as select * from #VoxcoSystemDatabaseName#.dbo.CAPI_FileReceived
GO


-- Refresh the VIEW Structure on VoxcoSystem.LongTableList table
IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'LongTableList') 
    DROP View [dbo].LongTableList 
GO
create view dbo.LongTableList as select * from #VoxcoSystemDatabaseName#.dbo.LongTableList
GO


-- Refresh the VIEW Structure on VoxcoSystem.SynchroLog table
IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'SynchroLog') 
    DROP View [dbo].SynchroLog 
GO
create view dbo.SynchroLog as select * from #VoxcoSystemDatabaseName#.dbo.SynchroLog
GO

-- Refresh the VIEW Structure on VoxcoSystem.SynchroLogDetails table
IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'SynchroLogDetails') 
    DROP View [dbo].SynchroLogDetails 
GO
create view dbo.SynchroLogDetails as select * from #VoxcoSystemDatabaseName#.dbo.SynchroLogDetails
GO


-- Refresh the VIEW Structure on VoxcoSystem.AgentSession table
IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'AgentSession') 
    DROP View [dbo].AgentSession 
GO
create view dbo.AgentSession as select * from #VoxcoSystemDatabaseName#.dbo.AgentSession
GO

--------------------------------------------
-- Create View based on Voxco_Project END
-- 
-- IMPORTANT : MUST BE THE LAST STATEMENT OF THE SCRIPT
-- IN CASE VoxcoSystemDatabaseName does not exists.
--------------------------------------------


-- ==========================================================
--
-- FGetSundayDate
-- Function qui retourne la date du n Dimanche du mois
-- @sundayindex at 5 veux dire le dernier dimanche du mois 
-- Avantage: Cette version n'utilise pas de table temporaire
-- ==========================================================
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FGetSundayDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[FGetSundayDate]
GO
CREATE Function [dbo].[FGetSundayDate] 
(
	@year int,  -- The Year
	@month int, -- The Month
	@sundayindex int --Sunday Index 1, 2, 3, 4 and 5 for the latest 
)
returns DateTime
AS
BEGIN
	-- new version september 2013
	-- Country datefirst mod
	declare @lastSundaydatefirstMod int
	declare @firstNSundaydatefirstMod int
	if ( @@datefirst = 1 )
	begin
		set @lastSundaydatefirstMod = 0
		set @firstNSundaydatefirstMod = 7
	end
	else
	begin
		set @lastSundaydatefirstMod = 1
		set @firstNSundaydatefirstMod = 8
	end

	declare @thedate DateTime
	set @thedate  = DATEADD(yyyy,@year-DATEPART(yyyy,GETDATE()),GETDATE()) 
	set @thedate = DATEADD(mm,@month-DATEPART(mm,@TheDate),@TheDate) 

	declare @firstSunday datetime
	declare @returnSunday datetime

	declare @lastdayofmonth datetime
	declare @firstdayofmonth datetime
	set @firstdayofmonth = DATEADD(dd,1-DAY(@thedate),@thedate)
	set @lastdayofmonth = DATEADD(mm,1,@firstdayofmonth) - 1

	declare @dayofweek int -- 1 sunday , 6 

	if ( @sundayindex < 5 )
	begin
		-- find the first n sunday
		set @dayofweek = DATEPART(dw,@firstdayofmonth);
		if ( @dayofweek = 8-@@datefirst )
			set @firstSunday = @firstdayofmonth
		else
			set @firstSunday = DATEADD(dd,@firstNSundaydatefirstMod-@dayofweek,@firstdayofmonth)

		set @returnSunday = DATEADD(dd,(@sundayindex-1)*7,@firstSunday)
	end
	else
	begin
		-- find the last sunday of the month
		set @dayofweek = DATEPART(dw,@lastdayofmonth);
		if ( @dayofweek =  8-@@datefirst )
			set @returnSunday = @lastdayofmonth
		else
			set @returnSunday = DATEADD(dd,@lastSundaydatefirstMod-@dayofweek,@lastdayofmonth)
	end
	RETURN @returnSunday
END

GO

-- ************************************************
--
-- FROM UTC
--
-- ************************************************
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_fn_FromUTC]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[VX_fn_FromUTC]
GO
CREATE FUNCTION [dbo].[VX_fn_FromUTC]
(
	@sourceDateTime DateTime,@timeZoneId int
)
RETURNS DateTime
AS
BEGIN
	-- new version september 2013
	--return the converted time base on timeZoneBias and DST of the source date
	declare @newdt datetime

	if ( @sourceDateTime > 2 )
	begin 

		-- Declare the return variable here
		declare @gmtbias float
		declare @dstbias float
		declare @stdmonth int
		declare @stdday int
		declare @dstmonth int
		declare @dstday int
		declare @dstactive bit
		
		declare @stddate DateTime
		declare @dstdate DateTime
		declare @sourceDateYear int

		SELECT	@gmtbias = gmtbias,
				@dstbias = dstbias,
				@dstactive = dstactive,
				@stdmonth = standardmonth,
				@stdday = standardday,
				@dstmonth = dstmonth,
				@dstday = dstday
		FROM TimeZones where id = @timeZoneId



		--Get the year of the source date
		set @sourceDateYear = DATEPART(yyyy,@sourceDateTime)
		
		--Get StandardTime  Starting date
		set @stddate = dbo.FGetSundayDate( @sourceDateYear, @stdmonth, @stdday)
		
		--Get Dst Time Starting date
		set @dstdate =  dbo.FGetSundayDate( @sourceDateYear, @dstmonth, @dstday)


		declare @isSourceDateDst bit
		set @isSourceDateDst = 0

		-- Determine wich one come first in the year Standard Time
		if ( @dstbias > 0 )
		begin
			if (  @stddate > @dstdate )
			begin
				if ( @sourceDateTime >= @dstdate AND  @sourceDateTime < @stdDate )
				begin
					set @isSourceDateDst = 1
				end
			end
			else
			begin
				if ( @sourceDateTime >= @stddate AND  @sourceDateTime < @dstDate )
				begin
					set @isSourceDateDst = 0
				end
				else
				begin
					set @isSourceDateDst = 1
				end
			end
		end
		
		if ( @isSourceDateDst = 1 )
		 begin
			set @newdt = DateAdd(mi,@gmtbias*60,@sourceDateTime)
			set @newdt = DateAdd(mi,@dstbias*60,@newdt)
		 end
		else
		 begin
			set @newdt = DateAdd(mi,@gmtbias*60,@sourceDateTime)
		 end

	end
	else
	begin  -- @sourceDateTime < 2, we do not convert these date, they are flag date
		set @newdt = @sourceDateTime;
	end

	-- Return the result of the function
	RETURN @newdt

END
GO


-- ************************************************
--
-- TO UTC
--
-- ************************************************
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_fn_ToUTC]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[VX_fn_ToUTC]
GO
CREATE FUNCTION [dbo].[VX_fn_ToUTC]
(
	@sourceDateTime DateTime,@timeZoneId int
)
RETURNS DateTime
AS
BEGIN
	-- new version september 2013
	--return the converted time base on timeZoneBias and DST of the source date
	declare @newdt datetime	

	if ( @sourceDateTime > 2 )
	begin
		-- Declare the return variable here
		declare @gmtbias float
		declare @dstbias float
		declare @stdmonth int
		declare @stdday int
		declare @dstmonth int
		declare @dstday int
		declare @dstactive bit
		
		declare @stddate DateTime
		declare @dstdate DateTime
		declare @sourceDateYear int

		SELECT	@gmtbias = gmtbias,
				@dstbias = dstbias,
				@dstactive = dstactive,
				@stdmonth = standardmonth,
				@stdday = standardday,
				@dstmonth = dstmonth,
				@dstday = dstday
		FROM TimeZones where id = @timeZoneId

		--Get the year of the source date
		set @sourceDateYear = DATEPART(yyyy,@sourceDateTime)
		
		--Get StandardTime  Starting date
		set @stddate = dbo.FGetSundayDate( @sourceDateYear, @stdmonth, @stdday)
		
		--Get Dst Time Starting date
		set @dstdate =  dbo.FGetSundayDate( @sourceDateYear, @dstmonth, @dstday)


		declare @isSourceDateDst bit
		set @isSourceDateDst = 0

		-- Determine wich one come first in the year Standard Time
		if ( @dstbias > 0 )
		begin
			if (  @stddate > @dstdate )
			begin
				if ( @sourceDateTime >= @dstdate AND  @sourceDateTime < @stdDate )
				begin
					set @isSourceDateDst = 1
				end
			end
			else
			begin
				if ( @sourceDateTime >= @stddate AND  @sourceDateTime < @dstDate )
				begin
					set @isSourceDateDst = 0
				end
				else
				begin
					set @isSourceDateDst = 1
				end
			end
		end

		--invert bias for "TO UTC"
		set @gmtbias = 0 - @gmtbias	
		set @dstbias = 0 - @dstbias

		if ( @isSourceDateDst = 1 )
		 begin
			set @newdt = DateAdd(mi,@gmtbias*60,@sourceDateTime)
			set @newdt = DateAdd(mi,@dstbias*60,@newdt)
		 end
		else
		 begin
			set @newdt = DateAdd(mi,@gmtbias*60,@sourceDateTime)
		 end

	end
	else
	begin  -- @sourceDateTime < 2, we do not convert these date, they are flag date
		set @newdt = @sourceDateTime;
	end

	-- Return the result of the function
	RETURN @newdt
END
GO


/* Add to Voxco_project(s) the function for splitting string */

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[fn_cte_SplitString]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
	drop function [dbo].[fn_cte_SplitString]
GO

CREATE FUNCTION [dbo].[fn_cte_SplitString] (
	@csv nvarchar(MAX),
	@sep nchar(1) = ',' 
) RETURNS TABLE 
AS
	RETURN
	WITH csvtbl(start, stop) AS (
		SELECT start = convert(bigint, 1),
				stop = charindex(@sep,
					@csv + convert(nvarchar(MAX), @sep))
	UNION ALL
	SELECT start = stop + 1,
		stop = charindex(@sep,
			@csv + convert(nvarchar(MAX), @sep), stop + 1)
	FROM   csvtbl
	WHERE  stop > 0
	)
	SELECT ltrim(rtrim(convert(nvarchar(4000),
		substring(@csv, start,
			CASE WHEN stop > 0 THEN stop - start ELSE 0 END)
		))) AS Value
	FROM   csvtbl
	WHERE  stop > 0
GO

